package gov.va.med.domain.service.messaging;

import gov.va.med.domain.DomainConstants;


/**
 * MessagingConstants
 *
 * @author PII
 * @version $Id: MessagingConstants.java,v 1.23 2005/11/14 21:07:44 slava.uchitel Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 */
public interface MessagingConstants {
	// Messaging framework parameters
	public static final String HL7_MESSAGE_LOGGING_PARAM = "messaging:HL7_MESSAGE_LOGGING";
	public static final String NAMING_DIRECTORY_REFRESH_INTERVAL = "messaging:NAMING_DIRECTORY_REFRESH_INTERVAL_IN_MINUTES";

	// Encoding parameters
	public static final String SENDING_FACILITY = "Sending Station Number";
	public static final String SENDING_FACILITY_DOMAIN = "Sending Station Domain";
	public static final String SENDING_APPLICATION = "Sending Application";
	public static final String RECEIVING_FACILITY_DOMAIN = "Receiving Station Domain";
	public static final String RECEIVING_APPLICATION = "Receiving Application";
	public static final String RECEIVING_FACILITY = "Receiving Station Number";
	public static final String SYSTEM_TYPE = "System Type";

	// Protocol parameters
	public static final String SOCKET_ADDRESS = "IP";
	public static final String SOCKET_PORT = "Port Number";
	public static final String FULLY_QUALIFIED_HOSTNAME = "DN";
	public static final String CALL_TIMEOUT_MSEC = "TimeOut";

	// Default station number to be used for request against MPI
	public final static String DEFAULT_MPI_STATION_NUMBER = "200M";
	public final static String MPI_PATIENT_LINK_FUNCTION = "linkPatient";
	public final static String MPI_PATIENT_UNLINK_FUNCTION = "unlinkPatient";
	public final static String MPI_PATIENT_LOOKUP_FUNCTION = "lookupPatient";
	public final static String MESSAGE_PROPERTY_REQUESTID = "REQUESTID";

	// Vista RemoteFunction names
	public static String PRESCRIPTION_REFILL_FUNCTION_NAME = "refillPrescription";
	public static String GET_ACTIVE_PRESCRIPTIONS_FUNCTION_NAME = "getPrescriptionStatus";
	public static String GET_ALL_PRESCRIPTIONS_FUNCTION_NAME = "getPrescriptionProfile";
	public static String GET_UPDATE_PRESCRIPTIONS_FUNCTION_NAME = "getPrescriptionUpdate" ;
	public static String GET_HEALTH_RECORD_UPDATES_FUNCTION_NAME = "getHealthRecordUpdates";
	public static String GET_COPAYS_FUNCTION_NAME = "getCopays";

	// HL7 spec constants
	public static final String ALWAYS_ACKNOWLEDGE = "AL";
	public static final String NEVER_ACKNOWLEDGE = "NE";
	public static final String EMPTY_STRING="";
	public static final String NULL_STRING="\"\"";
	public static final int QUERY_MODE_SYNCHRONOUS = 0;
	public static final int QUERY_MODE_ASYNCHRONOUS = 1;    
	public static final String DEFAULT_EXPECTED_HL7_VERSION = "2.4";
	public static final String CODED_ENTRY = "CE";
	public static final String PRIMARY_CARE_PROVIDER = "PP";

	// HL7 response OBX segment id constants
	public static final String SPECIMEN_ID = "22633-2"; 
	public static final String GROSS_DESCRIPTION_ID = "22634-0"; 
	public static final String MICROSCOPIC_DESCRIPTION_ID = "22635-7"; 
	public static final String BRIEF_CLINICAL_HISTORY_ID = "22636-5";
	public static final String SURGICAL_PATH_DIAGNOSIS_ID = "22637-3"; 
	public static final String SUPPLEMENTARY_REPORT_ID = "22639-9"; 
	public static final String PREOPERATIVE_DIAGNOSIS_ID = "10219-4"; 
	public static final String OPERATIVE_FINDINGS_ID = "10215-2";
	public static final String POSTOPERATIVE_DIAGNOSIS_ID = "10218-6";
	public static final String MICROSCOPY_GROSS_DESCRIPTION_ID = "22634-9";
	public static final String EM_DIAGNOSIS_ID = "22637-3";
	public static final String ICD_DIAGNOSIS_ID = "80.067D";

	//  Miscellaneous constants
	public static final String yyyyMMddFormat 			=  "yyyyMMdd";
	public static final String yyyyMMddHHmmFormat  		=  "yyyyMMddHHmm";
	public static final String yyyyMMddHHmmssFormat  	=  "yyyyMMddHHmmss";   
	public static final String yyyyMMddHHmmssSSSFormat  	=  "yyyyMMddHHmmss.SSS";   
	public static final String yyyyMMddHHmmssSSSZFormat  =  "yyyyMMddHHmmss.SSSZ";   
	public static final String SLASH_R = "\r";

	// Messaging Bean names for Spring - defined in /resourcse/messagingConstants.xml
	public static final String DESTINATION_LOADER_BEAN_NAME = "destinationLoader"; 
	public static final String JMS_SENDER_BEAN_NAME = "jmsSender"; 
	public static final String MESSAGE_ORIGINATOR_BEAN_NAME = "messageOriginatorService"; 
	public static final String MESSAGE_SENDER_BEAN_NAME = "messageSenderService"; 

	public static final String VISTA_PHR_REQUEST_MULTIPLEXOR_BEAN_NAME = "vistaPhrRequestMultiplexor"; 
	public static final String OUT_MESSAGE_DISPATCHER_BEAN_NAME = "outMessageDispatcher"; 
	public static final String DELIVERY_SERVICES_TRANSCEIVER_BEAN_NAME = "deliveryServicesTransceiver";
	public static final String HL7_MLLP_TRANSCEIVER_BEAN_NAME = "hl7MLLPTransceiver";
	public static final String HL7_DCLLP_TRANSCEIVER_BEAN_NAME = "hl7DCLLPTransceiver";
	public static final String MESSAGING_CONFIGURATION_DAO_BEAN_NAME = "messagingConfigurationDao";

	// Messaging DAO Bean names for Spring
	public static final String PATIENT_MESSAGING_REQUEST_DAO_BEAN_NAME = "PatientMessagingRequestDAO";
	public static final String MESSAGING_REQUEST_DAO_BEAN_NAME = "MessagingRequestDAO";
	public static final String MESSAGE_ERROR_DAO_BEAN_NAME = "MessageErrorDAO";
	public static final String MESSAGE_INVENTORY_DAO_BEAN_NAME = "MessageInventoryDAO";
	public static final String MESSAGE_CACHE_DAO_BEAN_NAME = "MessageCacheDAO";
	public static final String MESSAGE_LOGGING_DAO_BEAN_NAME = "MessageLoggingDAO";

	public static final String MESSAGING_CATEGORY_ACTIVITY_DAO_BEAN_NAME = "MessagingCategoryActivityDAO";
	public static final String MESSAGING_CATEGORY_TYPE_DAO_BEAN_NAME = "MessagingCategoryTypeDAO";
	public static final String CATEGORY_ACTIVITY_DAO_BEAN_NAME = "CategoryActivityDAO";
	public static final String CATEGORY_TYPE_DAO_BEAN_NAME = "CategoryTypeDAO";
	public static final String PHR_FUNCTION_DAO_BEAN_NAME = "MessagingPhrFunctionDAO";
	public static final String FUNCTION_DAO_BEAN_NAME = "MessagingFunctionDAO";

	// Global messaging parameters
	//public static final String MHV_SYSTEM_TYPE = MhvConfigService.getInstance().getParamValueString(DomainConstants.MHV_SYSTEM_TYPE);
	//public static final String MHV_STATION_NUMBER = MhvConfigService.getInstance().getParamValueString(DomainConstants.MHV_STATION_NUMBER);
	//TODO: Fix me - SRE
	public static final String MHV_SYSTEM_TYPE = DomainConstants.MHV_SYSTEM_TYPE;
	public static final String MHV_STATION_NUMBER = DomainConstants.MHV_STATION_NUMBER;
}
